package com.library.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
 
import com.library.dao.BookDao;
import com.library.dao.BookDaoImplementation;
import com.library.model.Book;

@WebServlet("/Book")
public class BookController extends HttpServlet 
{
	private BookDao dao;
    private static final long serialVersionUID = 1L;
    public static final String BOOK_LIST = "/bookList.jsp";
    public static final String INSERT_OR_EDIT = "/book.jsp";
 
    public BookController() {
        dao = new BookDaoImplementation();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		String forward = "";
        String action = request.getParameter( "action" );
 
        if( action.equalsIgnoreCase( "delete" ) ) {
            forward = BOOK_LIST;
            int bookId = Integer.parseInt( request.getParameter("bookId") );
            dao.deleteBook(bookId);
            request.setAttribute("books", dao.getAllBooks() );
        }
        else if( action.equalsIgnoreCase( "edit" ) ) {
            forward = INSERT_OR_EDIT;
            int bookId = Integer.parseInt( request.getParameter("bookId") );
            Book book = dao.getBookById(bookId);
            request.setAttribute("book", book);
        }
        else if( action.equalsIgnoreCase( "insert" ) ) {
            forward = INSERT_OR_EDIT;
        }
        else {
            forward = BOOK_LIST;
            request.setAttribute("books", dao.getAllBooks() );
     
        }
        RequestDispatcher view = request.getRequestDispatcher( forward );
        view.forward(request, response);
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		Book book = new Book();
        book.setTitle(request.getParameter("title"));
        book.setAuthor(request.getParameter("author"));
        book.setIsbn(request.getParameter("isbn"));
        book.setStock(Integer.parseInt(request.getParameter("stock")));
        String bookId = request.getParameter("bookId");
 
        if(bookId == null || bookId.isEmpty() )
            dao.addBook(book);
        else 
        {
            book.setBookId(Integer.parseInt(bookId));
            dao.updateBook(book);
        }
        RequestDispatcher view = request.getRequestDispatcher(BOOK_LIST);
        request.setAttribute("students", dao.getAllBooks());
        view.forward(request, response);
	}
}
