<?php

namespace App\Http\Controllers\backend;

use Illuminate\Http\Request;

use App\Http\Requests\reqRct;
use App\Http\Controllers\Controller;

use App\Models\Receptionist;

use App\User;

class RctCtrl extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $this->data['title'] = 'Data receptionist';
        $this->data['receptionist'] = Receptionist::orderBy('nip')->paginate(10);
        return view('backend.receptionist.index',$this->data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $this->data['title'] = 'Tambah Data receptionist';
       
        $this->data['jabatan'] = ['Receptionist'];
       
        return view('backend.receptionist.create',$this->data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(reqRct $request)
    {
        //
        $input = $request->all();
        $input['user_id'] = User::create(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'receptionist'])->id;
        Receptionist::create($input);
        return redirect()->route('receptionist.index')->with('info','receptionist Berhasil Ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $this->data['title'] = 'Edit Data receptionist';
        $this->data['receptionist'] = Receptionist::find($id);
       
        $this->data['jabatan'] = ['Receptionist'];
       
        return view('backend.receptionist.edit',$this->data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $input = $request->except('_method','_token','mhs_id');
        $mhs = Receptionist::find($id);
        $mhs->update($input);
        $input['user_id'] = User::find($mhs->user_id)->update(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'receptionist']);
        return redirect()->route('receptionist.index')->with('info','Data receptionist berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $nilai = Receptionist::find($id);
        $nilai->delete();
        return redirect()->route('receptionist.index')->with('info','Data receptionist berhasil dihapus');
    }
}
