<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Pembayaran;

use Carbon\Carbon;

use Illuminate\Support\Facades\DB ;

class PembayaranController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
     
     
        $search = \Request::get('search');
        $pembayarans = Pembayaran::where('nama','like','%'.$search.'%')->orderBy('id')->paginate(10);
        // dd($pembayarans);
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    { 
    	return view('pembayaran.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $this->validate($request,['nama'=> 'required', 'lama_menginap' => 'required', 'kontak' => 'required', 'jumlah_kamar' => 'required', 'check_in' => 'required', 'check_out' => 'required',]);

        $data = DB::table('tbl_kamar')
                ->select('tbl_kamar.*')
                ->where('tbl_kamar.id' ,'=',$request['jenis_kamar'])
                ->get();
         //dd($data,$request['jenis_kamar']);       

        $pembayaran = new Pembayaran;
        $pembayaran->nama = $request->nama;
        $pembayaran->jenis_kamar = $request->jenis_kamar;
        $pembayaran->lama_menginap = $request->lama_menginap;
        $pembayaran->kontak = $request->kontak;
        $pembayaran->total_harga = $data[0]->harga_kamar * $request->jumlah_kamar * $request->lama_menginap;
        $pembayaran->jumlah_kamar = $request->jumlah_kamar;
         $pembayaran->check_in = Carbon::parse($request->check_in)->format('Y-m-d');
        $pembayaran->check_out = Carbon::parse($request->check_out)->format('Y-m-d');
        $pembayaran->save();
        return redirect()->route('pembayaran.index')->with('info','Data berhasil ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pembayaran = Pembayaran::findOrFail($id);
        return view('pembayaran.show', compact('pembayaran'));
    }

     public function edit($id)
    {
        $pembayaran = Pembayaran::findOrFail($id);
    return view('pembayaran.edit', compact('pembayaran'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,['nama'=> 'required','jenis_kamar'=> 'required', 'lama_menginap' => 'required', 'kontak' => 'required', 'jumlah_kamar' => 'required', 'check_in' => 'required', 'check_out' => 'required',]);

           $data = DB::table('tbl_kamar')
                ->select('tbl_kamar.*')
                ->where('tbl_kamar.id' ,'=',$request['jenis_kamar'])
                ->get();
                
        $pembayaran = pembayaran::findOrFail($id);
        $pembayaran->nama = $request->nama;
        $pembayaran->jenis_kamar = $request->jenis_kamar;
        $pembayaran->lama_menginap = $request->lama_menginap;
        $pembayaran->kontak = $request->kontak;
        $pembayaran->total_harga = $data[0]->harga_kamar * $request->jumlah_kamar * $request->lama_menginap;
        $pembayaran->jumlah_kamar = $request->jumlah_kamar;
         $pembayaran->check_in = Carbon::parse($request->check_in)->format('Y-m-d');
        $pembayaran->check_out = Carbon::parse($request->check_out)->format('Y-m-d');
        $pembayaran->save();
        return redirect()->route('pembayaran.index')->with('info','Data berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $pembayaran = Pembayaran::findOrFail($id);
        $pembayaran->delete();
        return redirect()->route('pembayaran.index')->with('info','Data berhasil dihapus');
    }
   
}

