@extends('layouts.layout')

@section('content')
        <div class="col-md-12">
            <div class="card">
                <div class="header">
                    <h4 class="title">{{$title}}</h4>
                    <p class="category"></p>
                </div>
                <div class="content table-responsive table-full-width">
                    <table class="table table-striped">
                        <thead>
                            <th>NIP</th>
                            <th>Nama gmaster</th>
                            <th>Jabatan</th>
                            <th>Aksi</th>
                            <th><a href="{{route('gmaster.create')}}" class="btn btn-default"><span class="ti-plus"></span> Tambah gmaster</a></th>
                        </thead>
                        <tbody>
                            @foreach($gmaster as $mhs)
                            <form action="{{route('gmaster.destroy',$mhs->id)}}" method="post"  class="form-inline">
                            <tr>
                                <td>{{$mhs->nip}}</td>
                                <td>{{$mhs->nama_gmaster}}</td>
                                <td>{{$mhs->jabatan}}</td>
                                <td colspan="2">
                                    <a href="{{route('gmaster.edit',$mhs->id)}}" class="btn btn-info"><i class="ti-pencil-alt"></i></a>
                                    {{ csrf_field() }}
                                    <input type="hidden" name="_method" value="delete" >
                                    <button type="submit" class="btn btn-danger"><i class="ti-close"></i></a>
                                </td>
                            </tr>
                            </form>
                            @endforeach
                        </tbody>
                    </table>
                    {{$gmaster->links()}}
                </div>
            </div>
        </div>
@endsection