<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Profile;

class ProfileController extends Controller
{
	public function index()
	{
		$data = Profile::all();
		return view('profile.daftarProfile')->with('data',$data);
	}
	public function create()
	{
		return view('profile.createClient');
	}
	public function store(Request $request)
	{
		Profile::create($request->all());
		return redirect('profileMVC');
	}
	public function edit($id)
	{
		$data = Profile::find($id);
		return view('profile.editProfile')->with('data',$data);
	}
	public function update(Request $request, $id)
	{
		Profile::find($id)->update($request->all());
		return redirect('profileMVC');
	}
	public function destroy($id)
	{
		Profile::find($id)->delete();
		return redirect('profileMVC');
	}
	public function search(Request $request)
	{
		if($request->ajax())
		{
			$outputHtml = "";
			$clients = Profile::where('name','LIKE','%'.$request->search.'%')->get();
			if($clients)
			{
				foreach ($clients as $key => $client) {
					$outputHtml.='<tr>'.
					'<td>'.$client->id.'</td>'.
					'<td>'.$client->name.'</td>'.
					'<td>'.$client->sex.'</td>'.
					'<td>'.$client->idcard.'</td>'.
					'<td>'.$client->birthdate.'</td>'.
					'<td>'.$client->province.'</td>'.
					'<td>'.$client->district.'</td>'.
					'<td>'.$client->sector.'</td>'.
					'<td>'.'<img src="images/'.$client->image.'"style="max-width: 10em; max-height: 10em;">'.'</td>'.
					'<td>'.'<a href="profileMVC/'.$client->id.'/edit" class="btn btn-info" title="edit '.$client->name.'"><i class="glyphicon glyphicon-edit"></i></a>'.
					'<form action="profileMVC/'.$client->id.'" method="post">'.
					csrf_field().
					'<br/><input type="hidden" name="_method" value="delete"><button type="submit" class="btn btn-warning" title="delete '.$client->name.'"><i class="glyphicon glyphicon-trash"></i></button></form>'.
					'</td>'.
				'<tr>';
			}
			return Response($outputHtml);
		}

	}
}
}
