<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_r_kategori_kompetisi".
 *
 * @property integer $kompetisi_id
 * @property string $nama_kompetisi
 * @property string $deskripsi_kompetisi
 * @property string $biaya_kompetisi
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 */
class KategoriKompetisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_r_kategori_kompetisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama_kompetisi', 'deskripsi_kompetisi', 'biaya_kompetisi'], 'required'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['deleted'], 'integer'],
            [['nama_kompetisi', 'deskripsi_kompetisi'], 'string', 'max' => 40],
            [['biaya_kompetisi'], 'string', 'max' => 100],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'kompetisi_id' => 'Kompetisi ID',
            'nama_kompetisi' => 'Nama Kompetisi',
            'deskripsi_kompetisi' => 'Deskripsi Kompetisi',
            'biaya_kompetisi' => 'Biaya Kompetisi',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }
}
