<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_nilai_toefl".
 *
 * @property integer $nilai_toefl_id
 * @property integer $peserta_toefl_id
 * @property string $nama_peserta_toefl
 * @property integer $nilai_toefl
 * @property integer $tahun_ujian
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxPesertaToefl $pesertaToefl
 */
class NilaiToefl extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_nilai_toefl';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_toefl_id', 'nama_peserta_toefl', 'nilai_toefl', 'tahun_ujian'], 'required'],
            [['peserta_toefl_id', 'nilai_toefl', 'tahun_ujian', 'deleted'], 'integer'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['nama_peserta_toefl'], 'string', 'max' => 40],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['peserta_toefl_id'], 'exist', 'skipOnError' => true, 'targetClass' => PesertaToefl::className(), 'targetAttribute' => ['peserta_toefl_id' => 'peserta_toefl_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'nilai_toefl_id' => 'Nilai Toefl ID',
            'peserta_toefl_id' => 'Peserta Toefl ID',
            'nama_peserta_toefl' => 'Nama Peserta Toefl',
            'nilai_toefl' => 'Nilai Toefl',
            'tahun_ujian' => 'Tahun Ujian',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPesertaToefl()
    {
        return $this->hasOne(PesertaToefl::className(), ['peserta_toefl_id' => 'peserta_toefl_id']);
    }
}
