<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\NilaiToefl;

/**
 * NilaiToeflSearch represents the model behind the search form about `backend\modules\bhsx\models\NilaiToefl`.
 */
class NilaiToeflSearch extends NilaiToefl
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nilai_toefl_id', 'peserta_toefl_id', 'nilai_toefl', 'tahun_ujian', 'deleted'], 'integer'],
            [['nama_peserta_toefl', 'created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at', 'deleted_by'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = NilaiToefl::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'nilai_toefl_id' => $this->nilai_toefl_id,
            'peserta_toefl_id' => $this->peserta_toefl_id,
            'nilai_toefl' => $this->nilai_toefl,
            'tahun_ujian' => $this->tahun_ujian,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'deleted' => $this->deleted,
            'deleted_at' => $this->deleted_at,
        ]);

        $query->andFilterWhere(['like', 'nama_peserta_toefl', $this->nama_peserta_toefl])
            ->andFilterWhere(['like', 'created_by', $this->created_by])
            ->andFilterWhere(['like', 'updated_by', $this->updated_by])
            ->andFilterWhere(['like', 'deleted_by', $this->deleted_by]);

        return $dataProvider;
    }
}
