<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_pembayaran_kompetisi".
 *
 * @property integer $pembayaran_id
 * @property integer $peserta_kompetisi_id
 * @property string $tanggal_pembayaran
 * @property resource $bukti_pembayaran
 * @property string $status_pembayaran
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxRPesertaKompetisi $pesertaKompetisi
 */
class PembayaranKompetisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_pembayaran_kompetisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_kompetisi_id', 'tanggal_pembayaran', 'bukti_pembayaran', 'status_pembayaran'], 'required'],
            [['peserta_kompetisi_id', 'deleted'], 'integer'],
            [['tanggal_pembayaran', 'created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['bukti_pembayaran'], 'string'],
            [['status_pembayaran'], 'string', 'max' => 20],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['peserta_kompetisi_id'], 'exist', 'skipOnError' => true, 'targetClass' => PesertaKompetisi::className(), 'targetAttribute' => ['peserta_kompetisi_id' => 'peserta_kompetisi_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'pembayaran_id' => 'Pembayaran ID',
            'peserta_kompetisi_id' => 'Peserta Kompetisi ID',
            'tanggal_pembayaran' => 'Tanggal Pembayaran',
            'bukti_pembayaran' => 'Bukti Pembayaran',
            'status_pembayaran' => 'Status Pembayaran',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPesertaKompetisi()
    {
        return $this->hasOne(PesertaKompetisi::className(), ['peserta_kompetisi_id' => 'peserta_kompetisi_id']);
    }
}
