<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\Prodi;

/**
 * ProdiSearch represents the model behind the search form about `backend\modules\bhsx\models\Prodi`.
 */
class ProdiSearch extends Prodi
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['ref_kbk_id', 'jenjang_id', 'status', 'is_jenjang_all', 'is_public', 'is_hidden', 'deleted'], 'integer'],
            [['kbk_id', 'kpt_id', 'kbk_ind', 'singkatan_prodi', 'kbk_ing', 'nama_kopertis_ind', 'nama_kopertis_ing', 'short_desc_ind', 'short_desc_ing', 'desc_ind', 'desc_ing', 'updated_at', 'created_by', 'updated_by', 'deleted_at', 'deleted_by', 'created_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Prodi::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'ref_kbk_id' => $this->ref_kbk_id,
            'jenjang_id' => $this->jenjang_id,
            'status' => $this->status,
            'is_jenjang_all' => $this->is_jenjang_all,
            'is_public' => $this->is_public,
            'is_hidden' => $this->is_hidden,
            'updated_at' => $this->updated_at,
            'deleted' => $this->deleted,
            'deleted_at' => $this->deleted_at,
            'created_at' => $this->created_at,
        ]);

        $query->andFilterWhere(['like', 'kbk_id', $this->kbk_id])
            ->andFilterWhere(['like', 'kpt_id', $this->kpt_id])
            ->andFilterWhere(['like', 'kbk_ind', $this->kbk_ind])
            ->andFilterWhere(['like', 'singkatan_prodi', $this->singkatan_prodi])
            ->andFilterWhere(['like', 'kbk_ing', $this->kbk_ing])
            ->andFilterWhere(['like', 'nama_kopertis_ind', $this->nama_kopertis_ind])
            ->andFilterWhere(['like', 'nama_kopertis_ing', $this->nama_kopertis_ing])
            ->andFilterWhere(['like', 'short_desc_ind', $this->short_desc_ind])
            ->andFilterWhere(['like', 'short_desc_ing', $this->short_desc_ing])
            ->andFilterWhere(['like', 'desc_ind', $this->desc_ind])
            ->andFilterWhere(['like', 'desc_ing', $this->desc_ing])
            ->andFilterWhere(['like', 'created_by', $this->created_by])
            ->andFilterWhere(['like', 'updated_by', $this->updated_by])
            ->andFilterWhere(['like', 'deleted_by', $this->deleted_by]);

        return $dataProvider;
    }
}
