<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_request_kursus".
 *
 * @property integer $request_id
 * @property integer $user_has_role_id
 * @property string $nama_perequest
 * @property string $email
 * @property string $no_telp
 * @property string $kategori_kursus
 * @property string $tanggal_mulai
 * @property string $tanggal_berakhir
 * @property string $status_request
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxUserHasRole $userHasRole
 */
class RequestKursus extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_request_kursus';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'nama_perequest', 'email', 'no_telp', 'kategori_kursus', 'tanggal_mulai', 'tanggal_berakhir', 'status_request'], 'required'],
            [['user_id', 'deleted'], 'integer'],
            [['tanggal_mulai', 'tanggal_berakhir', 'created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['nama_perequest'], 'string', 'max' => 40],
            [['email', 'kategori_kursus', 'status_request'], 'string', 'max' => 20],
            [['no_telp'], 'string', 'max' => 25],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'user_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'request_id' => 'Request ID',
            'user_id' => 'User ID',
            'nama_perequest' => 'Nama Perequest',
            'email' => 'Email',
            'no_telp' => 'No Telp',
            'kategori_kursus' => 'Kategori Kursus',
            'tanggal_mulai' => 'Tanggal Mulai',
            'tanggal_berakhir' => 'Tanggal Berakhir',
            'status_request' => 'Status Request',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['user_id' => 'user_id']);
    }
}
