<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\bhsx\models\BiayaToefl */

$this->title = $model->biaya_id;
$this->params['breadcrumbs'][] = ['label' => 'Biaya Toefls', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="biaya-toefl-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->biaya_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->biaya_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'biaya_id',
            'membership',
            'biaya_test',
        ],
    ]) ?>

</div>
