<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\bhsx\models\PemenangKompetisi */

$this->title = $model->pemenang_kompetisi_id;
$this->params['breadcrumbs'][] = ['label' => 'Pemenang Kompetisis', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pemenang-kompetisi-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->pemenang_kompetisi_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->pemenang_kompetisi_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'pemenang_kompetisi_id',
            'peserta_kompetisi_id',
            'nama_peserta',
            'asal_sekolah',
            'posisi_juara',
            'tahun_kompetisi',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
            'deleted',
            'deleted_at',
            'deleted_by',
        ],
    ]) ?>

</div>
