<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\bhsx\models\Prodi */

$this->title = $model->ref_kbk_id;
$this->params['breadcrumbs'][] = ['label' => 'Prodis', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="prodi-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->ref_kbk_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->ref_kbk_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'ref_kbk_id',
            'kbk_id',
            'kpt_id',
            'jenjang_id',
            'kbk_ind',
            'singkatan_prodi',
            'kbk_ing',
            'nama_kopertis_ind',
            'nama_kopertis_ing',
            'short_desc_ind',
            'short_desc_ing',
            'desc_ind:ntext',
            'desc_ing:ntext',
            'status',
            'is_jenjang_all',
            'is_public',
            'is_hidden',
            'updated_at',
            'created_by',
            'updated_by',
            'deleted',
            'deleted_at',
            'deleted_by',
            'created_at',
        ],
    ]) ?>

</div>
