<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use File;
use App\Http\Requests;
use App\Models\Bus;
use App\Models\Users;
use App\Models\Supir;
use App\Models\Pemesanan;
use App\Models\Batal;
use App\Models\Konfirmasi;
use App\Models\Jadwal;
use Validator;
use App\Http\Controllers\Controller;
use App\User;
use Image;


class AdminController extends Controller
{
	public function store(Request $request){
        $input = $request->all();

		if($username = DB::table('users')->where('username' , $input['username'])->first()){
            return redirect()->back()->with('info','We are so sorry :-( .Username is exists. Please choose another username');
        }else{
        	User::create(['username' => $input['username'],'password' => bcrypt($input['password']),'role' => $input['role']])->id;
        return redirect(url('/admin/user'))->with('info box','Data User Berhasil ditambah');
        }
    }

    public function user(){
        $key = Input::get('search');
        $this->data['title'] = 'List User';
        if(isset($key)){
            $this->data['user'] = User::where('username','like','%'.$key.'%','and','role','!=','supir')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['user'] = User::where('role','!=','supir')->orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('users')->where('role','!=','supir')->get();
        return view('admin.user.index',$this->data);
    }

    public function tambahuser(){
        $this->data['title'] = 'Tambah User';
        return view('admin.user.tambah',$this->data);
    }
    public function hapususer($id){
        User::find($id)->delete();
        return redirect(url('/admin/user'))->with('info','Data User berhasil dihapus');
    }

    public function bus(){
        $key = Input::get('search');
        $this->data['title'] = 'Bus IT Del';
        if(isset($key)){
            $this->data['bus'] = Bus::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['bus'] = Bus::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('bus')->get();
        return view('admin.bus.index',$this->data);
    }

    public function tambahbus(){
        $this->data['title'] = 'Tambah Bus';
        return view('admin.bus.tambah',$this->data);
    }

    public function storebus(Request $request){
        $this->validate($request, [
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:3072',
        ]);
        $input = $request->all();
        $image = $request->file('image');
        $input['image'] = time().'.'.$image->getClientOriginalExtension();

        $destinationPath = public_path('/image');
        $img = Image::make($image->getRealPath());
        $img->resize(300, 300, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath.'/'.$input['image']);

        if($plat_bus = DB::table('bus')->where('plat_bus' , $input['plat_bus'])->first()){
            return redirect()->back()->with('info','We are so sorry :( .Plat bus is exists. Please enter another Plat Bus');
        }else{
            Bus::create($input);
            return redirect(url('/admin/bus'))->with('info','Data Bus berhasil ditambah');
        }
    }

    public function hapusbus($id){
        $bus = DB::table('bus')->where('id' , $id)->first();
        File::delete('image/' . $bus->image);
        Bus::find($id)->delete();
        return redirect(url('/admin/bus'))->with('info','Bus berhasil dihapus');
    }

    public function detail($id){
        $this->data['title'] = 'Detail Bus';
        $this->data['bus'] = Bus::find($id);
        return view('admin.bus.detail',$this->data);
    }

    public function ubah($id){
        $this->data['title'] = 'Ubah Data Bus';
        $this->data['bus'] = Bus::find($id);
        return view('admin.bus.ubah',$this->data);
    }

    public function ubahgambar($id){
        $this->data['title'] = 'Ubah Gambar Bus';
        $this->data['bus'] = Bus::find($id);
        return view('admin.bus.ubahgambar',$this->data);
    }

    public function edit(Request $request, $id){
        $this->validate($request, [
            'nama_bus' => 'required',
        ]);
        $bus = Bus::findOrFail($id);
        $bus->nama_bus = $request->nama_bus;

        $input = $request->all();
        if($request->file('image')){
            $this->validate($request, [
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:3048',
            ]);
            $bus = DB::table('bus')->where('id' , $id)->first();
            File::delete('image/' . $bus->image);
            $image = $request->file('image');
            $input['image'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/image');
            $img = Image::make($image->getRealPath());
            $img->resize(300, 300, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['image']);
            Bus::find($id)->update($input);
        }
        else{
            Bus::find($id)->update($input);
        }
        return redirect(url('/admin/bus'))->with('info','Data Bus Berhasil di Ubah');
    }

    public function editgambar(Request $request, $id){

        $input = $request->all();
        if($request->file('image')){
            $this->validate($request, [
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:3048',
            ]);
            $bus = DB::table('bus')->where('id' , $id)->first();
            File::delete('image/' . $bus->image);
            $image = $request->file('image');
            $input['image'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/image');
            $img = Image::make($image->getRealPath());
            $img->resize(300, 300, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['image']);
            Bus::find($id)->update($input);
        }
        else{
            Bus::find($id)->update($input);
        }
        return redirect(url('/admin/bus'))->with('info','Gambar Bus Berhasil di Ubah');
    }

    public function supir(){
        $key = Input::get('search');
        $this->data['title'] = 'Supir IT Del';
        if(isset($key)){
            $this->data['supir'] = Supir::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['supir'] = Supir::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('supir')->get();
        return view('admin.supir.index',$this->data);
    }

    public function tambahsupir(){
        $this->data['title'] = 'Tambah Supir';
        return view('admin.supir.tambah',$this->data);
    }

    public function storesupir(Request $request){
        $this->validate($request, [
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:3048',
        ]);
        $input = $request->all();
        $image = $request->file('image');
        $input['image'] = time().'.'.$image->getClientOriginalExtension();

        $destinationPath = public_path('/image');
        $img = Image::make($image->getRealPath());
        $img->resize(300, 300, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath.'/'.$input['image']);

        if($id = DB::table('supir')->where('id' , $input['id'])->first()){
            return redirect()->back()->with('info','We are so sorry :( .ID is exists. Please choose another ID');
        }else{
            Supir::create($input);
            return redirect(url('/admin/supir'))->with('info','Data Supir berhasil ditambah');
        }
    }

    public function hapussupir($id){
        $supir = DB::table('supir')->where('id' , $id)->first();
        File::delete('image/' . $supir->image);
        Supir::find($id)->delete();
        return redirect(url('/admin/supir'))->with('info','Supir berhasil dihapus');
    }

    public function detailsupir($id){
        $this->data['title'] = 'Detail Supir';
        $this->data['supir'] = Supir::find($id);
        return view('admin.supir.detail',$this->data);
    }

    public function ubahsupir($id){
        $this->data['title'] = 'Ubah Data Supir';
        $this->data['supir'] = Supir::find($id);
        return view('admin.supir.ubahsupir',$this->data);

    }

    public function editsupir(Request $request, $id){

        $input = $request->all();
        if($request->file('image')){
            $this->validate($request, [
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:3048',
            ]);
            $supir = DB::table('supir')->where('id' , $id)->first();
            File::delete('image/' . $supir->image);
            $image = $request->file('image');
            $input['image'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/image');
            $img = Image::make($image->getRealPath());
            $img->resize(300, 300, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['image']);
            Supir::find($id)->update($input);
        }
        else{
            Supir::find($id)->update($input);
        }
        return redirect(url('/admin/supir'))->with('info','Data Supir Berhasil di Ubah');
    }

    public function profil(){
        $this->data['title'] = 'Profil Anda';
        return view('admin.profil.index',$this->data);
    }

    public function history(){
        $key = Input::get('search');
        $this->data['title'] = ' Riwayat Pemesanan Bus IT Del';
        if(isset($key)){
            $this->data['batal'] = Batal::where('client_username','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
            $this->data['konfirmasi'] = Konfirmasi::where('client_username','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['batal'] = Batal::orderBy('id','desc')->paginate(10);
            $this->data['konfirmasi'] = Konfirmasi::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('batal')->get();
        $this->data['total'] = DB::table('konfirmasi')->get();
        return view('admin.history.index',$this->data);
    }

    public function hapus_history($id){
        $bata = DB::table('batal')->where('id' , $id)->first();
        Batal::find($id)->delete();
        return redirect(url('/admin/history'))->with('info','History berhasil dihapus');
    }

    public function hapus_history2($id){
        $konfir = DB::table('konfirmasi')->where('id' , $id)->first();
        Konfirmasi::find($id)->delete();
        return redirect(url('/admin/history'))->with('info','History berhasil dihapus');
    }

    public function pemesanan(){
        $key = Input::get('search');
        $this->data['title'] = 'Pemesanan Bus IT Del';
        if(isset($key)){
            $this->data['pemesanan'] = Pemesanan::where('client_username','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['pemesanan'] = Pemesanan::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('pemesanan')->get();
        return view('admin.pemesanan.index',$this->data);
    }

    public function detailpemesanan($id){
        $this->data['title'] = 'Detail Pemesanan';
        $this->data['pemesanan'] = Pemesanan::find($id);
        return view('admin.pemesanan.detail',$this->data);
    }

    public function tolak($id){
        pemesanan::find($id)->delete();
        return redirect(url('/admin/pemesanan'))->with('info','Pembatalan pemesanan berhasil dilakukan');
    }

    public function konfirmasi(Request $request, $id){
        $input = $request->all();
        Pemesanan::find($id)->update($input);
        return redirect(url('/admin/pemesanan/'))->with('info','Data Bus Berhasil di Ubah');
    }

}
