@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa fa-users"></i>Supir</li>
                    <li class="active"><i class="fa fa-users"></i>Update Jadwal Supir</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">

                    <div class="col-md-9">
                        <section class="invoice">
                            <!-- title row -->
                            <div class="row">
                                <div class="col-xs-12">
                                    <h2 class="page-header">
                                        <i class="fa fa-globe"></i> Jadwal Supir
                                        <small class="pull-right">Date: 2/10/2014</small>
                                    </h2>
                                </div>
                                <!-- /.col -->
                            </div>

                            <!-- info row -->
                            <div class="row invoice-info"></div>
                            <!-- Table row -->
                            <div class="row">
                                <div class="col-xs-12 table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                        <tr>
                                            <th>Hari</th>
                                            <th>Nama Supir 1</th>
                                            <th>Pukul</th>
                                            <th>Nama Supir 2</th>
                                            <th>Pukul</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($jadwal as $jad)
                                            <tr>
                                                <td><b>{{$jad->hari}}</b></td>
                                                <td>
                                                    {{$jad->nama_supir}}
                                                </td>
                                                <td>
                                                    {{$jad->pukul}}
                                                </td>
                                                <td>
                                                    {{$jad->nama_supir2}}
                                                </td>
                                                <td>
                                                    {{$jad->pukul2}}
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- /.box-footer -->
                            <div class="box-footer">
                                <a href="{{url('k_supir/supir/update_jadwal')}}" class="btn btn-info">Simpan</a>
                            </div>

                        </section>
                    </div>
                    <!-- /.col -->
                    <div class="col-md-3">
                        <!-- Box Comment -->
                        <div class="box box-widget">
                            <div class="box-header with-border">
                                <div class="user-block">
                                    <span class="username">Supir Terdaftar</span>
                                </div>
                                <!-- /.user-block -->
                                <div class="box-tools">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                    </button>
                                </div>
                                <!-- /.box-tools -->
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">

                                <table class="table table-hover">
                                    <thead><tr>
                                        <th>Nama Supir</th>
                                        <th>Gambar</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($supir as $supi)
                                        <tr>
                                            <td>
                                                <div id="external-events">
                                                    <div class="external-event bg-yellow ui-draggable ui-draggable-handle" style="position: relative;">
                                                        {{$supi->nama_supir}}
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="user-block">
                                                    <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('image/' . $supi->image) }}"/>
                                                </div>
                                            </td>
                                        </tr>
                                        </form>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.box-body -->
                            <!-- /.box-footer -->
                            <div class="box-footer"></div>
                            <!-- /.box-footer -->
                        </div>
                        <!-- /.box -->
                    </div>
                    <!-- /.col -->

                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif