@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Invitation
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Invitation</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Accepted Invitation
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                    	<th>Requester</th>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($Finvitations as $invitation)
					                        <tr>
					                        	<td>{{ $invitation->requester }}</td>
					                            <td>{{ $invitation->course_name }}</td>
					                            <td>{{ $invitation->class_name }}</td>
					                            <td>{{ $invitation->due_date }}</td>
					                            <td>{{ $invitation->due_time }}</td>
					                            <td>{{ $invitation->room_name }}</td>
					                            <td>{{ $invitation->type }}</td>
					                            <td>{{ $invitation->totalAttender }}</td>
					                            <td>{{ $invitation->status }}</td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					           
					        </div>
					    </div>
					    {{ $Finvitations->render() }}
					</div>
			</div>
		</div>
	</div>
@endsection
