package com.example.sammy.record_lahan.api;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.example.sammy.record_lahan.DatabaseHelper;

import java.sql.SQLException;
import java.util.ArrayList;

public class HomestayController {
    private DatabaseHelper db;
    private SQLiteDatabase database;

    public static final String TABLE_NAME = "data";
    public static final String ID = "id";
    public static final String NAMA_HOMESTAY = "nama_tanaman";
    public static final String ALAMAT_HOMESTAY = "lokasi";
    public static final String AREA_TERDEKAT = "ukuran";

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final String CREATE_HOMESTAY = "CREATE TABLE "+TABLE_NAME+ " " + "(" + ID + " INTEGER PRIMARY KEY AUTOINCREMENT," + NAMA_HOMESTAY + " TEXT," + ALAMAT_HOMESTAY + " TEXT,"
            + AREA_TERDEKAT + " TEXT ";

    private String[] TABLE_COLOUMNS = {ID, NAMA_HOMESTAY, ALAMAT_HOMESTAY, AREA_TERDEKAT};

    public HomestayController(Context context) {
        db = new DatabaseHelper(context);
    }

    public void close() {
        db.close();
    }

    public void open() throws SQLException {
        database = db.getWritableDatabase();
    }

    public void deleteData() {
        database.delete(TABLE_NAME, null, null);
    }

    public void insertData(int id, String nama_homestay, String alamat, String area_terdekat, String jumlah_kamar, String harga, String gambar) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(ID, id);
        contentValues.put(NAMA_HOMESTAY, nama_homestay);
        contentValues.put(ALAMAT_HOMESTAY, alamat);
        contentValues.put(AREA_TERDEKAT, area_terdekat);

        database.insert(TABLE_NAME, null, contentValues);
    }

    public ArrayList<homestayModel> getData() {
        ArrayList<homestayModel> allData = new ArrayList<homestayModel>();
        Cursor cursor = null;

        cursor = database.query(TABLE_NAME, TABLE_COLOUMNS, null, null, null, null, ID + " ASC");

        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            allData.add(parseData(cursor));
            cursor.moveToNext();
        }
        cursor.close();
        return allData;
    }

    private homestayModel parseData(Cursor cursor) {
        homestayModel curData = new homestayModel();

        curData.setId(cursor.getInt(0));
        curData.setNama_homestay(cursor.getString(1));
        curData.setAlamat(cursor.getString(2));
        curData.setArea_terdekat(cursor.getString(3));
        curData.setJumlah_kamar(cursor.getString(4));
        curData.setHarga(cursor.getString(5));
        curData.setGambar(cursor.getString(6));

        return curData;
    }
}
