package org.rest.resource;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.rest.dao.PemesananDAO;
import org.rest.model.Pemesanan;

public class PemesananResource {

    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    int id;

    public PemesananResource(UriInfo uriInfo, Request request, int id) 
    {
        this.uriInfo = uriInfo;
        this.request = request;
        this.id = id;
    }

    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public Pemesanan getPemesanan() 
    {
        Pemesanan pemesanan = getPemesanan(id, PemesananDAO.intance.getModel());
        System.out.println("Data pemesanan :" + pemesanan.getNama() + "\t" + pemesanan.getId());
        if (pemesanan == null) 
        {
            throw new RuntimeException("GET: Pemesanan " + id + " tidak ditemukan");
        }
        return pemesanan;
    }

    @GET
    @Produces(MediaType.TEXT_XML)
    public Pemesanan getPemesananHTML() 
    {
        Pemesanan pemesanan = getPemesanan(id, PemesananDAO.intance.getModel());
        if (pemesanan == null) 
        {
            throw new RuntimeException("GET: Pemesanan " + id + " tidak ditemukan");
        }
        return pemesanan;
    }

    @PUT
    @Consumes(MediaType.APPLICATION_XML)
    public Response setDataPemesanan(JAXBElement<Pemesanan> pemesananXML) 
    {
        Pemesanan c = pemesananXML.getValue();
        return putAndGetResponse(c);
    }

    @DELETE
    public void deletePemesanan() 
    {
        Pemesanan pemesanan = deletePemesanan(id, PemesananDAO.intance.getModel());
        if (pemesanan == null) {
            throw new RuntimeException("Delete: Pemesanan " + id + " tidak ditemukan");
        }
    }

    private Response putAndGetResponse(Pemesanan pemesanan) {
        Response res;
        if (getPemesanan(pemesanan.getId(), PemesananDAO.intance.getModel()) != null) {
            res = Response.noContent().build();
        } else {
            res = Response.created(uriInfo.getAbsolutePath()).build();
        }
        PemesananDAO.intance.getModel().add(pemesanan);
        return res;
    }

    public Pemesanan getPemesanan(int id, List<Pemesanan> pemesanans) 
    {
        for (Pemesanan m : pemesanans) 
        {
            if (m.getId() == id) 
            {
                return m;
            }
        }
        return null;
    }

    public Pemesanan deletePemesanan(int id, List<Pemesanan> pemesanans) {
        int indeks = 0;
        int indeksPemesananDiDelete = -1;
        for (Pemesanan m : pemesanans) {
            if (m.getId() == id) {
                indeksPemesananDiDelete = indeks;
                break;
            }
            indeks++;
        }
        if (indeksPemesananDiDelete != -1) {
            pemesanans.remove(indeksPemesananDiDelete);
            return pemesanans.get(indeksPemesananDiDelete);
        }
        return null;
    }
}
