<?php
$this->breadcrumbs = array(
    'Ruangans' => array('index'),
    'Manage',
);

$this->menu = array(
    array('label' => 'List Ruangan', 'url' => array('index')),
    array('label' => 'Create Ruangan', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
$('.search-form').toggle();
return false;
});
$('.search-form form').submit(function(){
$.fn.yiiGridView.update('ruangan-grid', {
data: $(this).serialize()
});
return false;
});
");
?>

<h1>Manage Ruangans</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>
        &lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button btn')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('booster.widgets.TbGridView', array(
    'id' => 'ruangan-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'ID',
        'SHORT_NAME',
        'NAME',
        'KAPASITAS',
        'KET',
        'STATUS',
        /*
          'LAST_UPDATE',
          'USER_ID',
          'WS',
          'RFID',
         */
        array(
            'class' => 'booster.widgets.TbButtonColumn',
        ),
    ),
));
?>
