<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Sentinel;
use App\User;

class RegistrationController extends Controller
{
    public function register()
    {
        return view('authentication.register');
    }

    public function postRegister(Request $request)
    {
        $this->validate($request, [
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'email' => 'required|unique:users',
            'password' => 'confirmed|required|min:6',
        ]);

        $user = Sentinel::registerAndActivate($request->all());

        $role = Sentinel::findRoleBySlug('customer');

        $role->users()->attach($user);

        return redirect('/login')->with('alert-success', 'Akun anda telah terdaftar. Silahkan login.');

    }
}
