@extends('layouts.master-customer')
@section('content')
<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h4> <a href="{{url('/customer')}}" class="fa fa-home"> Home</a> / <a href="#"> Upload</a> </h4>
            </div>
        </div>

        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Upload Resi Pembayaran</h2>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                        <form action="{{url('/data_order/upload/'.$orders->id)}}" method="post" enctype="multipart/form-data">
                            <input name="_method" type="hidden" value="PUT">
                            {{csrf_field()}}

                            <label>Tiket</label>
                            <div class="form-group{{ $errors->has('nama') ? ' has-error' : '' }}">
                                <input type="text" name="nama" class="form-control" value="{{$orders->nama}}" readonly>
                                {!! $errors->first('nama', '<p class="help-block">:message</p>') !!}
                            </div>

                            <label>Jumlah</label>
                            <div class="form-group{{ $errors->has('jumlah') ? ' has-error' : '' }}">
                                <input type="text" name="jumlah" class="form-control"  value="{{$orders->jumlah}}" readonly>
                                {!! $errors->first('jumlah', '<p class="help-block">:message</p>') !!}
                            </div>

                            <label>Total Harga</label>
                            <div class="form-group{{ $errors->has('harga') ? ' has-error' : '' }}">
                                <input type="text" name="harga" class="form-control" value="IDR{{$orders->harga}},-" readonly>
                                {!! $errors->first('harga', '<p class="help-block">:message</p>') !!}
                            </div>

                            <label>Upload Resi</label>
                            <div class="form-group{{ $errors->has('images') ? ' has-error' : '' }}">
                                <input type="file" id="inputimages" name="images" class="form-control">
                                {!! $errors->first('images', '<p class="help-block">:message</p>') !!}
                            </div>

                            <div class="form-group">
                                <input type="submit" class="btn btn-primary" value="Save">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /page content -->
@endsection
